/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__shim.h"
#include "mx__handle_map.h"

static const char __idstring[] = "@(#)$Id: mx__handle_map.c,v 1.9 2006/02/15 22:16:52 loic Exp $";

struct mx__handle_map *mx__hm_init(int count, int reserved)
{
  struct mx__handle_map *hm;
  int i;

  hm = mx_malloc(sizeof (*hm));
  if (hm != 0) {
    hm->map = mx_calloc (sizeof (*hm->map), count);
    if (hm->map != 0) {
      for (i = 0; i < count - 1; ++i) {
	hm->map[i].i = i+1;
      }
      hm->map[count - 1].i = -1;
      hm->free_count = count;
      hm->first_free = 0;
      hm->last_free = count - 1;
      hm->total_count = count;
      hm->reserved_count = reserved;
    }
    else {
      mx_free(hm);
      hm = 0;
    }
  }
  return hm;
}

void mx__hm_fini(struct mx__handle_map *hm)
{
  mx_free(hm->map);
  mx_free(hm);
}
